<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class DonationRequest extends Model 
{

    protected $table = 'donation_requests';
    public $timestamps = true;
    protected $fillable = array('patient_name', 'patient_age', 'blood_type_id', 'bags_num', 'hospital_address', 'hospital_name', 'city_id', 'phone', 'longitude', 'latitude', 'client_id');

    public function blood_type()
    {
        return $this->hasOne('App\Model\BloodType');
    }

    public function notification()
    {
        return $this->belongsTo('App\Model\Notification');
    }

}